## Requirements

- python 3.9.5
- numpy 1.20.3
- scipy 1.7.3
- numba 0.54.1
- pandas 1.3.4
- tqdm 4.62.3
- p_tqdm
- scikit-learn 1.0.1
- scikit-uplift 0.4.0


## Dataset Preparation

No data preparation is needed for the Gaussian Uplift experiment. 
For the other two experiments, please use files provided in the `prepare_dataset` folder, e.g.:
```
> python3 prepare_dataset/prepare_criteo_bernoulli.py
```
The prepared data will be saved in the `save` directory.

## Usage

Please refer to the scripts provided in the `scripts` folder. 
We provide below an example for running UpUCB for Gaussian Uplift
```
> python3 main_gaussian_uplift.py --algo='UpUCB' --radius=2 --n_rounds=10000
```
Once the programs are executed, the results are saved in the `save` directory.

For the Gaussian and Bernoulli uplift experiments the regrets and the arm histories are saved. 
For the targeted campaign experiment only the total uplifts of the selected individuals and the total rewards are saved.
Therefore, additional procedure is required to compute the regret. This is possible because the random seeds are fixed, but the codes are not provided here. (Briefly speaking, we use the `update_treat_optimal` method of `C2UpBandit` to compute the optimal uplifts and the optimal rewards.)
